const express = require('express');
const router = express.Router();
const reviewController = require('../controllers/reviewController');
const { authenticate, authorize, optionalAuth } = require('../middleware/auth');

// Public routes
router.get('/detailer/:detailerId', optionalAuth, reviewController.getDetailerReviews);

// Detailer routes
router.get('/my-reviews', authenticate, authorize('detailer'), reviewController.getMyReviews);

// Client routes
router.post('/', authenticate, authorize('client'), reviewController.createReview);
router.put('/:id', authenticate, authorize('client'), reviewController.updateReview);

module.exports = router;
