const express = require('express');
const router = express.Router();
const paymentController = require('../controllers/paymentController');
const { authenticate, authorize } = require('../middleware/auth');
const { webhookLimiter, apiLimiter } = require('../middleware/rateLimiter');

// Apply rate limiting to all payment routes
router.use(apiLimiter);

// PayChangu routes
router.post('/initialize', authenticate, authorize('client'), paymentController.initializePayChangu);
router.post('/callback', webhookLimiter, paymentController.paymentCallback); // Public webhook endpoint with signature verification and rate limiting
router.get('/return', (req, res, next) => {
  console.log('[ROUTE] Payment return endpoint accessed:', {
    url: req.originalUrl,
    query: req.query,
    timestamp: new Date().toISOString(),
  });
  next();
}, paymentController.paymentReturn); // Public return URL endpoint
router.post('/verify-status', authenticate, authorize('client'), paymentController.verifyPaymentStatus);
router.post('/poll-status', authenticate, authorize('client'), paymentController.pollPaymentStatus); // Poll payment status
router.post('/verify-by-tx-ref', authenticate, authorize('client'), paymentController.verifyPaymentByTxRef); // NEW: Verify payment by transaction reference

module.exports = router;