const express = require('express');
const router = express.Router();
const detailerController = require('../controllers/detailerController');
const { authenticate, authorize, optionalAuth } = require('../middleware/auth');
const upload = require('../config/upload');

// Public routes
router.get('/', optionalAuth, detailerController.getAllDetailers);

// Detailer routes (must come before :id route)
router.get('/dashboard', authenticate, authorize('detailer'), detailerController.getDashboardStats);
router.get('/dashboard/stats', authenticate, authorize('detailer'), detailerController.getDashboardStats);
router.put('/profile', authenticate, authorize('detailer'), upload.single('profile_image'), detailerController.updateProfile);
router.put('/availability', authenticate, authorize('detailer'), detailerController.updateAvailability);
router.get('/payment-settings', authenticate, authorize('detailer'), detailerController.getPaymentSettings);
router.put('/payment-settings', authenticate, authorize('detailer'), detailerController.updatePaymentSettings);
router.get('/payouts/summary', authenticate, authorize('detailer'), detailerController.getPayoutSummary);
router.post('/payouts/request', authenticate, authorize('detailer'), detailerController.requestPayout);

// Photo routes
router.post('/photos', authenticate, authorize('detailer'), upload.array('photos', 4), detailerController.uploadPhotos);
router.get('/:id/photos', optionalAuth, detailerController.getPhotos);
router.delete('/photos/:photoId', authenticate, authorize('detailer'), detailerController.deletePhoto);
router.put('/photos/:photoId/primary', authenticate, authorize('detailer'), detailerController.setPrimaryPhoto);

// Public detail route (must be last)
router.get('/:id', optionalAuth, detailerController.getDetailerById);

module.exports = router;
