const express = require('express');
const router = express.Router();
const clientController = require('../controllers/clientController');
const { authenticate, authorize } = require('../middleware/auth');
const upload = require('../config/upload');

// Client routes
router.get('/profile', authenticate, authorize('client'), clientController.getProfile);
router.put('/profile', authenticate, authorize('client'), upload.single('profile_image'), clientController.updateProfile);
router.get('/dashboard', authenticate, authorize('client'), clientController.getDashboardStats);
router.get('/dashboard/stats', authenticate, authorize('client'), clientController.getDashboardStats);

module.exports = router;
