const db = require('./src/config/database');

async function debugPhotos() {
  try {
    // Check what photos exist for detailer 13
    const [allPhotos] = await db.query(
      'SELECT * FROM detailer_photos WHERE detailer_id = 13'
    );
    console.log('All photos for detailer 13:', allPhotos);

    // Check photos with gallery type
    const [galleryPhotos] = await db.query(
      'SELECT * FROM detailer_photos WHERE detailer_id = 13 AND photo_type = "gallery"'
    );
    console.log('Gallery photos for detailer 13:', galleryPhotos);

    // Check photos with gallery type and is_deleted = 0
    const [activePhotos] = await db.query(
      'SELECT * FROM detailer_photos WHERE detailer_id = 13 AND photo_type = "gallery" AND is_deleted = 0'
    );
    console.log('Active gallery photos for detailer 13:', activePhotos);

    // Check the exact query from getPhotos function
    const [exactQuery] = await db.query(
      `SELECT id, photo_url, photo_type, is_primary, sort_order, created_at
       FROM detailer_photos 
       WHERE detailer_id = 13 AND photo_type = 'gallery' AND is_deleted = 0
       ORDER BY sort_order ASC`
    );
    console.log('Exact query result:', exactQuery);

  } catch (error) {
    console.error('Debug error:', error);
  }
}

debugPhotos();